


;*****************************************************************************************************************************************************
;																									
;	( VERTICES-POL-01 )																					
;																									
;	CREA (1) SECCION POLIGONAL de (1) SPLINE PLANA FIJANDO EL ANGULO ENTRE LADOS CONSECUTIVOS DEL POLIGONO							
;																									
;*****************************************************************************************************************************************************



;	*******************************************
;	************** EN EGECUCION ***************
;	*******************************************






;=====================================================================================================================================================
;									*** ***  SUB-PROGRAMAS  *** ***											
;=====================================================================================================================================================


;	PINTA PUNTOS de (LIS-PX) con Texto-N   (COMPROVACION)															

	(DEFUN PINTA-PUN ( / )

		(SETQ N1 -1 )
		(REPEAT (LENGTH LIS-PINTA-P)
			(SETQ N1 (+ N1 1))
			(SETQ PAAn (NTH N1 LIS-PINTA-P))
			(COMMAND "COLOR" COLO "PUNTO" PAAn)  ; COLO
			; (COMMAND "TEXTO" PAAn 0.02 90 N1)
		) ; repeat

	) ; PINTA-PUN

;																									


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	SPLINE-X   GRADUA SPLINE ( NX00 ) con ( DISgra ) => LISTA PUNTOS ( LIS-PX+2 )  											
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ENTRADA  : / NX00 / DISgra /																				
;	INTERNAS : / ALIS / AELE / AELES / X-primer / X-ultimo / N-enti-A1 / LIS-PX / W1A / N-enti-A2 / PX-primer / PX-ultimo /    / N1 / PAAn / 		
;	SALIDA   : / LIS-PX+2 /																					
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(DEFUN SPLI-X ( / )

		(SETQ ALIS  (ENTGET NX00))  									; lista Spline A
		(SETQ AELE  (ASSOC 10 ALIS))  								; 1 Punto Asociado a 10 (10.punto)
		(SETQ AELES (MEMBER AELE ALIS)) 								; lista a partir del Alterior (10.punto)....(11.punto)
		(SETQ X-primer (CDR (NTH 0 AELES))) 							; primer elemento (10.punto)
		(SETQ X-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))				; ultimo elemento (11.punto)
		(COMMAND "COLOR" COLO "TEXTO" X-primer 0.2 90 TEX)					; TEXTO = A
		(COMMAND "PUNTO" X-primer)									; PINTA 1 punto A
		(SETQ N-enti-A1 (ENTLAST))									; nombre ultima entidad principal 1 punto A
		(COMMAND "GRADUA" NX00 DISgra)								; GRADUA SPLI-A
		(COMMAND "PUNTO" X-ultimo)									; PINTA Ultimo Punto A
	
		;	PUNTOS SECCION-A (PA1-PAn) =>   LIS-PX  Lon-LPA															
		(SETQ LIS-PX nil)											; LISTA  PUNTOS-A
		(SETQ LIS-PX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A1))) LIS-PX))			; lista entidad -> (1 Punto-A)
		(SETQ W1A T)
		(WHILE W1A
			(SETQ N-enti-A2 (ENTNEXT N-enti-A1))						; Nombre entidad siguiente
			(COMMAND "BORRA" N-enti-A1 "")
			(IF (= N-enti-A2 nil)  (SETQ W1A nil)
				(PROGN
					(SETQ LIS-PX (CONS (CDR (ASSOC 10 (ENTGET N-enti-A2))) LIS-PX))
					(SETQ N-enti-A1  N-enti-A2 )
				);progn
			);if
		) ;While W1A

		;	LISTA ( LIS-PX ) Ordenada																		

		(SETQ LIS-PX  (REVERSE LIS-PX ))	; ( LIS-PX Ordenada )
		(SETQ N-PX  (LENGTH LIS-PX ))

		;																							


		;-----------------------------------------------------------------------------------------------------------------------------------------
		;	AADE MARGEN ( MAR ) <SOLAPE> a ( LIS-PX ) por DETRAS ( MAR ) Primeros y por DELANTE ( MAR ) Ultimos => ( LIS-PX+M* )			
		;																							
		;-----------------------------------------------------------------------------------------------------------------------------------------
		;																							
			(SETQ MAR 10 )	; N de PUNTOS QUE AADE A (LIS-PX) COMO MARGEN por DELANTE y por DETRAS => 2 x MAR => (LIS-PX+mar)			
		;																							
		;																							
		;-----------------------------------------------------------------------------------------------------------------------------------------



		;	AADE a ( LIS-PX Ordenada ) como PRIMEROS los ( MAR Ultimos) de ( LIS-PX Ordenada )			

		(SETQ LIS-PX+mar LIS-PX)

		(SETQ Nu 0)
		(REPEAT MAR
			(SETQ Nu (+ Nu 1))
			(SETQ LIS-PX+mar (CONS (NTH (- (LENGTH LIS-PX) Nu ) LIS-PX ) LIS-PX+mar ))
		) ;repe

		;	AADE a ( LIS-PX+M* Ordenada ) como ULTIMOS los ( MAR Primeros) de ( LIS-PX Ordenada )		

		(SETQ LIS-PX+mar (REVERSE LIS-PX+mar ))	; ( LIS-PX Invertida )

		(SETQ Np -1)
		(REPEAT MAR
			(SETQ Np (+ Np 1))
			(SETQ LIS-PX+mar (CONS (NTH Np LIS-PX ) LIS-PX+mar ))
		) ;repe

		;	LISTA ( LIS-PX+mar ) Ordenada																		

		(SETQ LIS-PX+mar (REVERSE LIS-PX+mar ))	; ( LIS-PX Ordenada )
		(SETQ N-PX+mar  (LENGTH LIS-PX+mar ))

		;																							


		;	PINTA PUNTOS de ( LIS-PINTA-P ) con Texto-N   (COMPROVACION)		

		; (SETQ LIS-PINTA-P LIS-PX     )  (PINTA-PUN)
		; (SETQ LIS-PINTA-P LIS-PX+mar )  (PINTA-PUN)	; CON MARGEN

		;													


	) ; Defun SPLI-X

;																									


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ANGULO con el (EJE-X SCU) de la TANGENTE en P2 al CIRCULO OSCULADOR de P1 P2 P3	=>  LIS-AngX+1 = ( LIST AgT P2 DISx T2 )			
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(DEFUN ANG-PX ( / )

			(SETQ LIS-AngX nil)
			(SETQ Nag -1 )
			(REPEAT (- (LENGTH LIS-P+mar) 2)

				(SETQ Nag (+ Nag 1))

				(SETQ P1 (NTH (+ Nag 0) LIS-P+mar))
				(SETQ P2 (NTH (+ Nag 1) LIS-P+mar))
				(SETQ P3 (NTH (+ Nag 2) LIS-P+mar))

				;	PUNTOS MEDIOS entre P1 P2 P3 => ( M12 M23 ) en SCP											

				(SETQ M12  (LIST (+ (CAR P1) (/ (- (CAR P2) (CAR P1)) 2)) (+ (CADR P1) (/ (- (CADR P2) (CADR P1)) 2)) 0))
				(SETQ M23  (LIST (+ (CAR P2) (/ (- (CAR P3) (CAR P2)) 2)) (+ (CADR P2) (/ (- (CADR P3) (CADR P2)) 2)) 0))

				;	PERPENDICULAR AL PUNTO MEDIO ( M12 M23 ) => ( P12 P23 ) en SCP									

				(SETQ P12 (LIST (+ (CAR M12) (- (CADR P2) (CADR M12)) ) (- (CADR M12) (- (CAR P2) (CAR M12)) ) 0))
				(SETQ P23 (LIST (+ (CAR M23) (- (CADR P3) (CADR M23)) ) (- (CADR M23) (- (CAR P3) (CAR M23)) ) 0))

				;	INTERSECCION PERPENDICULARES P-Mediaos (CENTRO CIRCULO OSCULADOR P1 P2 P3 ) => ( CEN )					

				(SETQ CEN (INTERS M12 P12  M23 P23 nil))	; SCP

				;	NORMAL AL RADIO ( P2 - CEN ) => TANGENTE ( P2 - T2 ) en SCP										

				(IF (/= CEN nil)
					(PROGN
						(SETQ T2 (LIST (- (CAR P2) (- (CADR P2) (CADR CEN)) ) (- (CADR P2) (- (CAR CEN) (CAR P2)) ) 0))

						(SETQ AgT (ANGLE P2 T2 ))

						; (COMMAND "COLOR" COLO "LINEA" P2 T2 "")	; TANGENTE

						(SETQ DISx (CAR (INTERS P2 T2 (LIST 0 0 0) (LIST 10 0 0) nil) ))

						(SETQ LIS-AngX (CONS (LIST AgT P2 DISx T2 ) LIS-AngX))	; LISTA ANGULOS

					) ;progn
				) ;if IN
			) ; repeat
 
		;	LISTA ( LIS-AngX )																			

		(SETQ LIS-AngX+1 (REVERSE LIS-AngX))		; *** LIS-AngX+1 Ordenada *** 

		;																							

	) ; Defun ANG-PX

;																									




;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	MARCA TRAMOS entre PUNTOS de INFLEXION y MAXIMOS y MINIMOS ( con CIRCULO y TEXTO)											
;	toma datos de ( LIS-AngX+1 )->(LIST AgT P2 DISx T2 ) =>															
;									=> debuelve ( LIS-TraTODO ) -> (( LIS-Tra0 )...( LIS-Tra0 )) -> ( LIST Ng1 Dg1 Pg1  Dg2 Pg2 )	
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(DEFUN MARCA-Tramos ( / )

		(SETQ LIS-TraTODO nil)
		(SETQ LIS-TraMAX  nil)
		(SETQ LIS-TraESE  nil)

		(SETQ PRINER-MAX T)

		(SETQ Ng1 -1 )
		(REPEAT (- (LENGTH LIS-Ang+1) 1)

			(SETQ Ng1 (+ Ng1 1))
			(SETQ Ng2 (+ Ng1 1))

			(SETQ LL1 (NTH Ng1 LIS-Ang+1))	; (LIST AgT P2 DISx T2 )
			(SETQ LL2 (NTH Ng2 LIS-Ang+1))

			(SETQ Ag1 (NTH 0 LL1))	; Angulo Tang con TRAZA
			(SETQ Ag2 (NTH 0 LL2))

			(SETQ Pg1 (NTH 1 LL1))	; Punto P2 (Tang P2 T2)
			(SETQ Pg2 (NTH 1 LL2))

			;(SETQ Dg1 (NTH 2 LL1))	; Distancia de la INTERSECCION de TANG en EjeX SCU
			;(SETQ Dg2 (NTH 2 LL2))

			(SETQ Tg1 (NTH 3 LL1))	; Punto T2 (Tang P2 T2)
			(SETQ Tg2 (NTH 3 LL2))

			;																						
			;	( LIS-TraESE ) => (LIST Ng1 Dg1 Pg1) o (LIST Ng2 Dg2 Pg2)												
			;																						



			;	PUNTOS MEDIOS entre Pg1 Pg2  => ( Mg12  ) 														

			(SETQ Mg12  (LIST (+ (CAR   Pg1) (/ (- (CAR   Pg2) (CAR   Pg1)) 2))
						(+ (CADR  Pg1) (/ (- (CADR  Pg2) (CADR  Pg1)) 2))
						(+ (CADDR Pg1) (/ (- (CADDR Pg2) (CADDR Pg1)) 2)) ))

			;	POR CADA DOS CUADRANDES 																	
			(COND
				( (OR (= Ag1 0 ) (= Ag1 PI ) (= Ag1 (* 2 PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg1 0.03 )
					(PROMPT " ****** ( TANG-1 ) => PARALELA a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )

				( (OR (= Ag2 0 ) (= Ag2 PI ) (= Ag2 (* 2 PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg2 0.03 )
					(PROMPT " ****** ( TANG-2 ) => PARALELA a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )

				( (OR (= Ag1 (* (/ 1.0 2.0) PI) ) (= Ag1 (* (/ 3.0 2.0) PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg1 0.03 )
					(PROMPT " ****** ( TANG-1 ) => PERTENDICULAR a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )

				( (OR (= Ag2 (* (/ 1.0 2.0) PI) ) (= Ag2 (* (/ 3.0 2.0) PI)) )
					(COMMAND "COLOR" 7  "CIRCULO" Pg2 0.03 )
					(PROMPT " ****** ( TANG-2 ) => PERTENDICULAR a TRAZA en Ng1 = ") 	(PRIN1 Ng1) (TERPRI) )


				( (OR (AND (< (* 0 PI)  Ag1  (* 1 PI) ) (< (* 1 PI) Ag2 (* 2 PI)))	; (Ag1) Emcima y (Ag2) Debajo del EJE-X
				      (AND (< (* 0 PI)  Ag2  (* 1 PI) ) (< (* 1 PI) Ag1 (* 2 PI))) )	; (Ag1) Debajo y (Ag2) Emcima del EJE-X

					(COND

						;	(Ag1) y (Ag2) al MISMO LADO del EJE-Y  =>       (1) PUNTO DE MAXIMO O MINIMO (MAX) 1				

						( (AND (= PRINER-MAX T)
							(OR (AND (< (* 0.5 PI)  Ag1  (* 1.5 PI)) (< (* 0.5 PI) Ag2 (* 1.5 PI)) )	; (Ag1)(Ag2) en 2-3 Cuadrante
						 	    (AND (OR (< (* 0.0 PI)  Ag1  (* 0.5 PI)) (< (* 1.5 PI) Ag1 (* 2.0 PI)) )	; (Ag1)(Ag2) en 1-4 Cuadrante
								   (OR (< (* 0.0 PI)  Ag2  (* 0.5 PI)) (< (* 1.5 PI) Ag2 (* 2.0 PI)) ))))

							(COMMAND "COLOR" 2 "CIRCULO" "2P" Pg1 Pg2  "CIRCULO" Mg12 0.04 )			; MAXIMOS O MINIMOS
							(COMMAND "COLOR" COLO "TEXTO" Pg1 0.04 90 Ng1  "TEXTO" Pg2 0.04 90 Ng2 )

							(SETQ LIS-TraTODO nil)
							(SETQ LIS-TraMAX  nil)
							(SETQ LIS-TraESE  nil)

							(SETQ LIS-TraESE (CONS (LIST Ng2 Ag2 Pg2 Tg2) LIS-TraESE) ) ;			(2) **************** (2)
							(SETQ Nsegun  Ng2)

							(SETQ PRINER-MAX nil)

							(SETQ P-ULTIMO Pg2)
						)

						;	(Ag1) y (Ag2) al MISMO LADO del EJE-Y  =>       (NO 1) PUNTOS DE MAXIMO O MINIMO (MAX) no1			

						( (AND (= PRINER-MAX nil)
							(OR (AND (< (* 0.5 PI)  Ag1  (* 1.5 PI)) (< (* 0.5 PI) Ag2 (* 1.5 PI)) )	; (Ag1)(Ag2) en 2-3 Cuadrante
						          (AND (OR (< (* 0.0 PI)  Ag1  (* 0.5 PI)) (< (* 1.5 PI) Ag1 (* 2.0 PI)) )	; (Ag1)(Ag2) en 1-4 Cuadrante
							         (OR (< (* 0.0 PI)  Ag2  (* 0.5 PI)) (< (* 1.5 PI) Ag2 (* 2.0 PI)) ))))

							(COMMAND "COLOR" 2 "CIRCULO" "2P" Pg1 Pg2  "CIRCULO" Mg12 0.04 )			; MAXIMOS O MINIMOS
							(COMMAND "COLOR" COLO "TEXTO" Pg1 0.04 90 Ng1  "TEXTO" Pg2 0.04 90 Ng2 )

							(IF (EQUAL Pg1 P-ULTIMO)

								(PROGN
									(SETQ LIS-TraESE  (CONS (LIST Ng1 Ag1 Pg1 Tg1) LIS-TraESE) ) ; 	(1) **************** (1)
									(SETQ LIS-TraMAX  (CONS (REVERSE LIS-TraESE) LIS-TraMAX) )
									(SETQ LIS-TraTODO (CONS (REVERSE LIS-TraMAX) LIS-TraTODO) )
								) ;progn

								(PROGN
									(SETQ LIS-TraESE  (CONS (LIST Ng1 Ag1 Pg1 Tg1) LIS-TraESE) ) ; 	(1) **************** (1)
									(SETQ LIS-TraMAX  (CONS (REVERSE LIS-TraESE) LIS-TraMAX) )
									(SETQ LIS-TraTODO (CONS (REVERSE LIS-TraMAX) LIS-TraTODO) )
									(SETQ LIS-TraESE  nil )
									(SETQ LIS-TraMAX  nil )

									(SETQ LIS-TraESE  (CONS (LIST Ng2 Ag2 Pg2 Tg2) LIS-TraESE) ) ;	(2) **************** (2)
									(SETQ Nsegun  Ng2)

								) ;progn
							) ;if
						)

						;	(Ag1) y (Ag2) a DISTINTO LADO del EJE-Y  =>     PUNTOS DE INFLESION (ESE)						

						( (OR (AND (< (* 0.5 PI)  Ag1  (* 1.5 PI)) (OR (< (* 0.0 PI)  Ag2  (* 0.5 PI)) (< (* 1.5 PI) Ag2 (* 2.0 PI)) ) )
							(AND (< (* 0.5 PI)  Ag2  (* 1.5 PI)) (OR (< (* 0.0 PI)  Ag1  (* 0.5 PI)) (< (* 1.5 PI) Ag1 (* 2.0 PI)) ) ) )

							(COMMAND "COLOR" 4 "CIRCULO" "2P" Pg1 Pg2  "CIRCULO" Mg12 0.04 )			; INFLESION
							(COMMAND "COLOR" COLO "TEXTO" Pg1 0.04 90 Ng1  "TEXTO" Pg2 0.04 90 (+ Ng1 1) )


							(SETQ LIS-TraESE (CONS (LIST Ng1 Ag1 Pg1 Tg1) LIS-TraESE) ) ;  			(1) **************** (1)
							(SETQ LIS-TraMAX (CONS (REVERSE LIS-TraESE) LIS-TraMAX) )

							(SETQ LIS-TraESE nil )
							(SETQ LIS-TraESE (CONS (LIST Ng2 Ag2 Pg2 Tg2) LIS-TraESE) ) ;  			(2) **************** (2)
							(SETQ Nsegun  Ng2)
						)
					
					) ;con
				)


				;	(PROMPT " *** ANGULOS NO SIGULARES en Ng1 = ") (PRIN1 Ng1) (TERPRI)									

				(  T  (IF (NOT (EQUAL Ng1 Nsegun))
					  	(SETQ LIS-TraESE (CONS (LIST Ng1 Ag1 Pg1 Tg1) LIS-TraESE)) ) ) ; 				(1) **************** (1)

			) ;con

		) ;repeat

		(SETQ LIS-TraTODO (REVERSE LIS-TraTODO) )

	) ; Defun MARCA-Tramos


;																									



;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		( LtraA ) => ( (LmaxA) ... ... ... ... ... ... (LmaxA) )													
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		( LmaxA )       => ( (LIS-ese-A) ... ... ... ... (LIS-ese-A) )													
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;		( LIS-ese-A )   => ( ( (Ng Ag Pg Tg) ...  ...  (Ng Ag Pg Tg) )													
;=====================================================================================================================================================
;	BUSCA TANGENTES CONSECUTIVAS que SU ANG sea MULTIPLO de AngBASE Y CALCULA su INTERSECCION => PINTA SECCION-POLOGUNAL					
;-----------------------------------------------------------------------------------------------------------------------------------------------------

	(DEFUN BUSCA-ANG ( / )

			(SETQ LIS-TANG nil)

			(SETQ Na1 -1) (REPEAT (LENGTH LtraA) 		  (SETQ LmaxA (NTH (SETQ Na1 (+ Na1 1)) LtraA))
				(SETQ Na2 -1) (REPEAT (LENGTH LmaxA) 	  (SETQ LeseA (NTH (SETQ Na2 (+ Na2 1)) LmaxA))
					(SETQ Na3 -1) (REPEAT (LENGTH LeseA) (SETQ LeeA  (NTH (SETQ Na3 (+ Na3 1)) LeseA))		; (Ng Ag Pg Tg)

						(SETQ Na1 (NTH 0 LeeA))
						(SETQ Aa1 (NTH 1 LeeA))		; ?????????? ERROR-BREAK (NTH -1 nil) error: tipo de argumento errneo: consp nil
						(SETQ Pa1 (NTH 2 LeeA))
						(SETQ Ta1 (NTH 3 LeeA))

						(IF (EQUAL (REM Aa1 AngBASE) (/ AngBASE 5) )	; <= ???????????? 

							(PROGN

								(SETQ LIS-TANG (CONS (LIST Na1 Aa1 Pa1 Ta1) LIS-TANG) )

							) ; pro
						) ; if
					) ;repe Na3
				) ;repe Na2
			) ;repe Na1


		;	COPIA la PRIMERA EL ULTIMO																		

		(SETQ LIS-TANG (CONS (NTH (- (LENGTH LIS-TANG) 1) LIS-TANG ) LIS-TANG) )

		(SETQ LIS-TANG (REVERSE LIS-TANG))


	) ; BUSCA-ANG

;																									







;=====================================================================================================================================================
;=====================================================================================================================================================
;																									
;	  *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA ***		
;																									
;=====================================================================================================================================================
;=====================================================================================================================================================


(DEFUN C:VERTICES-POL-01 (/ )
  
	;	ARRANCANDO																						
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES"  "SCP" "U"  "ORTO" "DES")

	;-----------------------------------------------------------------------------------------------------------------------------------------------
	;	FIJA PARAMETROS																					
	;-----------------------------------------------------------------------------------------------------------------------------------------------
	;																								
				(SETQ DISgra  0.1 )			; DISTANCIA para GRADUA  (0.07)										
	;																								
				(SETQ AngBASE (* (/ PI 180) 5 ))	; ANGULO ENTRE LADOS CONSECUTIVOS DEL POLIGONO (5 g) 							
	;																								
	;-----------------------------------------------------------------------------------------------------------------------------------------------


		;	SELECCCION DE SECCION																			

		(TERPRI) (SETQ NA00  (CAR (ENTSEL" MARCA --- SPLINE ABIERTA-3D --- SECCION-A ? "))) 			; nombre Spline A 

		;	GRADUA ( SPLINE-X ) con ( DISgra ) =>  (LENGTH LIS-PX+2)													

		(TERPRI) (SETQ NX00 NA00  COLO 1 TEX "A" )  (SPLI-X)  (SETQ  LIS-PA LIS-PX   LIS-PA+mar LIS-PX+mar )	; (LENGTH LIS-PA) 


		;	TANGENTE CIRTULO OSCULADO 3-Punto-X ( LIS-AngX+1 ) => (LIST AgT P2 DISx T2)										

		(SETQ LIS-P+mar LIS-PA+mar   COLO 1 ) (ANG-PX) (SETQ LIS-AngA+1 LIS-AngX+1)					; (LENGTH LIS-AngA+1) 


		;																							
		;	LOCALIZA PUNTOS (MAXIMOS MINIMOS) e (INFLEXION)  PINTA CIRCULOS Y N DE LOS PUNTOS									
		;																							
		;	=> (LIS-TraTODO) ( SUBLISTA de TODOS los TRAMOS ) 														
		;										(LIS-TraTODO-A) 	=> ( (LmaxA) ... ... ... (LmaxA) )					
		;										(LmaxA)     	=> ( (LIS-ese-A) ... ... (LIS-ese-A) )				
		;										(LIS-ese-A) 	=> (  LIST Ng1 Ag1 Pg1 )						
		;																							

		(SETQ LIS-Ang+1 LIS-AngA+1   COLO 1 ) (MARCA-Tramos) 	(SETQ LIS-TraTODO-A  LIS-TraTODO)			; (LENGTH LIS-TraTODO-A)


		;																							


		;																							
		;	BUSCA TANGENTES CONSECUTIVAS que SU ANG Ssea MULTIPLO de AngBASE Y CALCULA su INTERSECCION => PINTA SECCION-POLOGUNAL			

		(SETQ LtraA  LIS-TraTODO-A) (BUSCA-ANG) 		; => (LENGTH LIS-TANG)
















  

; LIS-TraTODO-A													

(QUOTE

(
  (
    ((11 -200.24 (8.52866 8.36973 -1.73481e-013)) (12 -96.8762 (8.42885 8.36372 -1.7278e-013 )) (13 -63.0032 (8.32934 8.3539 -1.72118e-013 )) (14 -46.1387 (8.23025 8.34046 -1.7149e-013 )) (15 -36.0191 (8.13169 8.32358 -1.70896e-013)) (16 -29.255  (8.03375 8.30342 -1.70335e-013)) (17 -24.4015  (7.9365 8.28012  -1.69803e-013)) (18 -20.7387 (7.84003 8.25382 -1.693e-013  )) (19 -17.8677  (7.74438 8.22463 -1.68825e-013)) (20 -15.5497 (7.64963 8.19268 -1.68375e-013)) (21 -13.6329 (7.55582 8.15804 -1.6795e-013)) (22 -12.0161 (7.46301 8.12082 -1.67549e-013)) (23 -10.6296 (7.37124 8.08109 -1.6717e-013)) (24 -9.42346 (7.28057 8.03892 -1.66812e-013)) (25 -8.36107 (7.19105 7.99437 -1.66475e-013)) (26 -7.41503 (7.10272 7.9475 -1.66158e-013)) (27 -6.5644 (7.01563 7.89835 -1.65859e-013)) (28 -5.79286 (6.92985 7.84696 -1.65578e-013)) (29 -5.08753 (6.84542 7.79337 -1.65314e-013)) (30 -4.4381 (6.76242 7.73761 -1.65068e-013)) (31 -3.83622 (6.68089 7.6797 -1.64837e-013)) (32 -3.27503 (6.60091 7.61967 -1.64621e-013)) (33 -2.74887 (6.52256 7.55754 -1.6442e-013)) (34 -2.25301 (6.4459 7.49332 -1.64234e-013)) (35 -1.78346 (6.37104 7.42702 -1.64061e-013)) (36 -1.33683 (6.29806 7.35866 -1.63902e-013)) (37 -0.910239 (6.22706 7.28825 -1.63756e-013)) (38 -0.501195 (6.15814 7.21579 -1.63622e-013)) (39 -0.107551 (6.09143 7.14129 -1.63501e-013)) (40 0.272559 (6.02706 7.06478 -1.63391e-013)) (41 0.640762 (5.96514 6.98625 -1.63293e-013)) (42 0.998478 (5.90584 6.90573 -1.63206e-013)) (43 1.34688 (5.84933 6.82327 -1.6313e-013)) (44 1.6872 (5.79573 6.73885 -1.63064e-013)) (45 2.02031 (5.74524 6.65254 -1.63008e-013)) (46 2.34704 (5.69804 6.56439 -1.62961e-013)) (47 2.66809 (5.65433 6.47445 -1.62924e-013)) (48 2.98406 (5.6143 6.38282 -1.62895e-013)) (49 3.29546 (5.57815 6.28959 -1.62875e-013)) (50 3.60267 (5.54609 6.19488 -1.62863e-013)) (51 3.90602 (5.5183 6.09883 -1.62858e-013)) (52 4.20573 (5.49499 6.0016 -1.6286e-013)) (53 4.50194 (5.47631 5.90337 -1.62869e-013)) (54 4.7947 (5.46243 5.80434 -1.62883e-013)) (55 5.08403 (5.45347 5.70476 -1.62902e-013)) (56 5.36576 (5.44951 5.60485 -1.62926e-013)) (57 5.60646 (5.45048 5.50486 -1.62952e-013)) (58 5.76674 (5.45518 5.40497 -1.62975e-013)) (59 5.8382 (5.46199 5.3052 -1.62985e-013)))
    ((60 5.82106 (5.46932 5.20547 -1.62971e-013)) (61 5.70811  (5.47547 5.10566 -1.62922e-013)) (62 5.48216  (5.47843 5.00571 -1.62822e-013)) (63 5.11115  (5.47562 4.90578 -1.62653e-013)) (64 4.54044  (5.46363 4.80655 -1.62388e-013)) (65 3.70726  (5.43803 4.71    -1.61996e-013)) (66   2.64868 (5.39505 4.61989 -1.61455e-013)) (67 1.48972  (5.33639 4.53905 -1.60792e-013)) (68 0.324612  (5.26623 4.46789 -1.60052e-013)) (69 -0.776586 (5.18837 4.40521 -1.5927e-013)) (70 -1.75418 (5.10554 4.34922 -1.58472e-013)) (71 -2.56304 (5.01955 4.29819 -1.57672e-013)) (72 -3.17355 (4.93159 4.25062 -1.56881e-013)) (73 -3.57198 (4.84245 4.20531 -1.56104e-013)) (74 -3.76005 (4.7527 4.16122 -1.55347e-013)))
    ((75 -3.7529 (4.66277 4.11748 -1.54614e-013)) (76 -3.57577 (4.57305 4.07332 -1.53908e-013)) (77 -3.25995 (4.48388 4.02805 -1.53235e-013)) (78 -2.83892 (4.39563 3.98103 -1.52597e-013)) (79 -2.36599 (4.30868 3.93164 -1.52001e-013)) (80 -1.92156 (4.22333 3.87954 -1.51449e-013)) (81  -1.54367 (4.13959 3.82489 -1.50938e-013)) (82 -1.22113 (4.05743 3.76789 -1.50466e-013)) (83 -0.941406 (3.97682 3.70871 -1.50032e-013)) (84 -0.695186 (3.89776 3.64748 -1.49632e-013)) (85 -0.475357 (3.82022 3.58434 -1.49265e-013)) (86 -0.2763 (3.74421 3.51936 -1.48931e-013)) (87 -0.0934126 (3.66974 3.45261 -1.48627e-013)) (88 0.0772546 (3.59684 3.38415 -1.48353e-013)) (89 0.23931 (3.52558 3.314 -1.48108e-013)) (90 0.396332 (3.45602 3.24215 -1.47892e-013)) (91 0.552268 (3.38831 3.16855 -1.47707e-013)) (92 0.712067 (3.32265 3.09314 -1.47551e-013)) (93 0.88295 (3.25934 3.01573 -1.47428e-013)) (94 1.07739 (3.19889 2.93608 -1.4734e-013)) (95 1.32234 (3.14224 2.85368 -1.47295e-013)) (96 1.69408 (3.09144 2.76759 -1.47306e-013)) (97 2.4686 (3.05237 2.67571 -1.47416e-013)) (98 4.29156 (3.04935 2.57755 -1.47786e-013)) (99 9.43971 (3.12576 2.51914 -1.48526e-013)) (100 238.137 (3.22499 2.50956 -1.4923e-013)))
  )
  
  (
    ((101 -18.6801 (3.32466 2.51706 -1.49874e-013)) (102 -10.9386 (3.42348 2.53226 -1.50485e-013)) (103 -8.43508 (3.52157 2.55178 -1.51078e-013)) (104 -7.20772 (3.61906 2.57401 -1.5166e-013 )) (105 -6.49356 (3.71613 2.59804 -1.52234e-013)) (106 -6.04079 (3.81288 2.62333 -1.52804e-013)) (107 -5.7416  (3.90939 2.64949 -1.53372e-013)) (108 -5.54201 (4.00574 2.67627 -1.5394e-013 )) (109 -5.41204 (4.10197 2.70347 -1.54507e-013)) (110 -5.33376 (4.19812 2.73094 -1.55076e-013)) (111 -5.29587 (4.29423 2.75855 -1.55646e-013)))
    ((112 -5.291   (4.39026 2.78621 -1.56218e-013)) (113 -5.31422 (4.48636 2.81385 -1.56794e-013)) (114 -5.36225 (4.58248 2.84139 -1.57372e-013)) (115 -5.43291 (4.67865 2.86879 -1.57954e-013)) (116 -5.52492 (4.77495 2.896   -1.5854e-013 )) (117 -5.63735 (4.87125 2.92294 -1.5913e-013 )) (118 -5.77004 (4.96764 2.9496  -1.59725e-013)) (119 -5.92311 (5.06411 2.97592 -1.60323e-013)) (120 -6.09709 (5.16068 3.00188 -1.60927e-013)) (121 -6.29283 (5.25735 3.02745 -1.61536e-013)) (122 -6.51154 (5.35414 3.05259 -1.62149e-013)) (123 -6.75478 (5.45104 3.07728 -1.62768e-013)) (124 -7.02448 (5.54806 3.10148 -1.63393e-013)) (125 -7.32298 (5.64521 3.12518 -1.64023e-013)) (126 -7.65314 (5.74249 3.14834 -1.64659e-013)) (127 -8.01834 (5.8399 3.17093 -1.65302e-013)) (128 -8.42266 (5.93745 3.19295 -1.6595e-013)) (129 -8.87095 (6.03513 3.21434 -1.66605e-013)) (130 -9.36905 (6.13295 3.2351 -1.67266e-013)) (131 -9.92403 (6.2309 3.2552 -1.67934e-013)) (132 -10.5445 (6.329 3.27461 -1.68608e-013)) (133 -11.2408 (6.42724 3.2933 -1.6929e-013)) (134 -12.0261 (6.52561 3.31125 -1.69978e-013)) (135 -12.9166 (6.62412 3.32844 -1.70674e-013)) (136 -13.9327 (6.72276 3.34484 -1.71378e-013)) (137 -15.1009 (6.82154 3.36041 -1.72089e-013)) (138 -16.4554 (6.92045 3.37514 -1.72807e-013)) (139 -18.0419 (7.01948 3.38899 -1.73534e-013)) (140 -19.9223 (7.11864 3.40194 -1.74268e-013)) (141 -22.1829 (7.21791 3.41396 -1.75011e-013)) (142 -24.9474 (7.31729 3.42501 -1.75762e-013)) (143 -28.3998 (7.41678 3.43507 -1.76522e-013)) (144 -32.8262 (7.51637 3.4441 -1.7729e-013)) (145 -38.697 (7.61605 3.45208 -1.78067e-013)) (146 -46.8439 (7.71581 3.45897 -1.78853e-013)) (147 -58.8891 (7.81564 3.46473 -1.79647e-013)) (148 -78.4749 (7.91553 3.46934 -1.80451e-013)) (149 -115.836 (8.01547 3.47276 -1.81265e-013)) (150 -215.029 (8.11545 3.47495 -1.82088e-013)) (151 -1257.67 (8.21545 3.47587 -1.8292e-013))) 
  )
  
  (
    ((152 340.792 (8.31544 3.47549 -1.83762e-013)) (153 152.927 (8.41543 3.47378 -1.84614e-013)) (154 99.9073 (8.51538 3.47069 -1.85476e-013)) (155 75.3088 (8.61528 3.46619 -1.86348e-013)) (156 61.3968 (8.7151 3.46031 -1.8723e-013 )) (157 52.5085 (8.81484 3.45308 -1.8812e-013)) (158 46.3465 (8.91448 3.44455 -1.8902e-013 )) (159 41.8288 (9.014 3.43476 -1.89928e-013 )) (160 38.3789 (9.11339 3.42373 -1.90843e-013)) (161 35.6618 (9.21264 3.41152 -1.91767e-013)) (162 33.4692 (9.31174 3.39815 -1.92697e-013)) (163 31.6648 (9.41069 3.38366 -1.93635e-013)) (164 30.156 (9.50947 3.36808 -1.94579e-013)) (165 28.8772 (9.60808 3.35146 -1.95529e-013)) (166 27.7811 (9.70651 3.33381 -1.96486e-013)) (167 26.8325 (9.80476 3.31518 -1.97448e-013)) (168 26.0046 (9.90282 3.29559 -1.98415e-013)) (169 25.2768 (10.0007 3.27508 -1.99388e-013)) (170 24.633 (10.0984 3.25367 -2.00365e-013)) (171 24.0602 (10.1959 3.23139 -2.01347e-013)) (172 23.5482 (10.2932 3.20827 -2.02334e-013)) (173 23.0886 (10.3903 3.18434 -2.03325e-013)) (174 22.6744 (10.4872 3.15962 -2.0432e-013)) (175 22.2999 (10.5839 3.13414 -2.05318e-013)) (176 21.9604 (10.6803 3.10794 -2.0632e-013)) (177 21.6518 (10.7766 3.08103 -2.07326e-013)) (178 21.3707 (10.8728 3.05343 -2.08335e-013)) (179 21.1142 (10.9687 3.02517 -2.09347e-013)) (180 20.8799 (11.0644 2.99628 -2.10362e-013)) (181 20.6656 (11.16 2.96678 -2.1138e-013)) (182 20.4696 (11.2553 2.9367 -2.124e-013)) (183 20.2903 (11.3505 2.90605 -2.13422e-013)) (184 20.1262 (11.4456 2.87486 -2.14448e-013)) (185 19.9764 (11.5404 2.84316 -2.15474e-013)) (186 19.8398 (11.6351 2.81098 -2.16503e-013)) (187 19.7156 (11.7296 2.77834 -2.17534e-013)) (188 19.6031 (11.824 2.74527 -2.18566e-013)) (189 19.5018 (11.9182 2.71178 -2.196e-013)) (190 19.4112 (12.0123 2.67792 -2.20635e-013)) (191 19.3312 (12.1063 2.64372 -2.21671e-013)) (192 19.2614 (12.2001 2.60919 -2.22707e-013)) (193 19.2021 (12.2939 2.57439 -2.23745e-013)) (194 19.1533 (12.3875 2.53936 -2.24783e-013)) (195 19.1156 (12.4811 2.50411 -2.25821e-013)) (196 19.0896 (12.5747 2.46873 -2.26859e-013)) (197 19.0765 (12.6681 2.43325 -2.27897e-013)))
    ((198 19.0777 (12.7616 2.39775 -2.28933e-013)) (199 19.0958 (12.8551 2.36229 -2.29969e-013)) (200 19.134  (12.9486 2.32696 -2.31003e-013)) (201 19.1975 (13.0423 2.29186 -2.32035e-013)) (202 19.2943 (13.136 2.25718 -2.33063e-013)) (203 19.4373 (13.23 2.22306 -2.34087e-013 )) (204 19.6489 (13.3243 2.18975 -2.35106e-013)) (205 19.9714 (13.419 2.15762 -2.36116e-013)) (206 20.4965 (13.5142 2.1272 -2.37116e-013 )) (207 21.4682 (13.6103 2.09934 -2.38098e-013)) (208 23.844 (13.7074 2.07559 -2.39052e-013)) (209 39.8442 (13.806 2.05926 -2.39953e-013)))
  )
  
  (
    ((210 7.31671 (13.9057 2.05987 -2.40715e-013)) (211 12.8308 (13.9853 2.11288 -2.40872e-013)) (212 14.3741 (13.9855 2.21118 -2.40032e-013)) (213 14.9662 (13.951 2.30488  -2.38966e-013)) (214 15.2429 (13.9051 2.39371 -2.37856e-013)) (215 15.4252 (13.8535 2.47934 -2.3673e-013 )) (216 15.5706 (13.7981 2.56258 -2.35595e-013)) (217 15.6991 (13.7397 2.6438  -2.34456e-013)) (218 15.8201 (13.679 2.72324  -2.33313e-013)) (219 15.9389 (13.6161 2.80101 -2.32168e-013)) (220 16.0592 (13.5513 2.87718 -2.31023e-013)) (221 16.184 (13.4847 2.95177 -2.29877e-013)) (222 16.3161 (13.4164 3.02476 -2.28731e-013)) (223 16.4583 (13.3463 3.09613 -2.27586e-013)) (224 16.6136 (13.2746 3.16581 -2.26442e-013)) (225 16.7856 (13.2012 3.23372 -2.25301e-013)) (226 16.9788 (13.1261 3.29976 -2.24162e-013)) (227 17.1987 (13.0493 3.36381 -2.23028e-013)) (228 17.4527 (12.9708 3.4257 -2.21898e-013)) (229 17.7492 (12.8905 3.48524 -2.20775e-013)) (230 18.0723 (12.8083 3.54225 -2.19659e-013)) (231 18.3712 (12.7245 3.59689 -2.18553e-013)) (232 18.6054 (12.6396 3.64969 -2.1746e-013)) (233 18.7548 (12.554 3.70125 -2.16382e-013)))
    ((234 18.8006 (12.4679 3.7522  -2.15322e-013)) (235 18.7253 (12.3819 3.8032  -2.14283e-013)) (236 18.5146 (12.2964 3.85504 -2.13267e-013)) (237 18.1588 (12.2119 3.90858 -2.12281e-013)) (238 17.6545 (12.1293 3.96486 -2.11329e-013)) (239 17.0062 (12.0495 4.02513 -2.10424e-013)) (240 16.2283 (11.9741 4.09083 -2.09579e-013)) (241 15.3476 (11.9056 4.16353 -2.08817e-013)) (242 14.4056 (11.8471 4.24453 -2.08173e-013)) (243 13.4585 (11.8028 4.33403 -2.07686e-013)) (244 12.61 (11.7761 4.43026 -2.07389e-013)) (245 11.9642 (11.766 4.52966 -2.07266e-013)) (246 11.5286 (11.7674 4.62961 -2.07263e-013)) (247 11.2511 (11.7763 4.7292 -2.07335e-013)) (248 11.0952 (11.7895 4.82832 -2.07449e-013)) (249 11.0398 (11.8047 4.92715 -2.07578e-013)))
    ((250 11.0744 (11.8202 5.02596 -2.07702e-013)) (251 11.196  (11.8341 5.12498 -2.07802e-013)) (252 11.3999 (11.8449 5.22439 -2.07859e-013)) (253 11.6508 (11.851 5.32419  -2.07855e-013)) (254 11.9106 (11.8524 5.42417 -2.0779e-013 )) (255 12.171  (11.8489 5.5241  -2.07663e-013)) (256 12.432  (11.8407 5.62375 -2.07478e-013)) (257 12.6937 (11.828 5.72293  -2.07236e-013)) (258 12.9562 (11.8108 5.82144 -2.06939e-013)) (259 13.2198 (11.7894 5.9191 -2.06591e-013)) (260 13.4848 (11.7639 6.01578 -2.06193e-013)) (261 13.7514 (11.7344 6.11134 -2.05749e-013)) (262 14.0201 (11.7012 6.20566 -2.05262e-013)) (263 14.2913 (11.6644 6.29864 -2.04734e-013)) (264 14.5656 (11.6242 6.3902 -2.04167e-013)) (265 14.8436 (11.5808 6.48028 -2.03564e-013)) (266 15.1258 (11.5343 6.5688 -2.02928e-013)) (267 15.4132 (11.4849 6.65573 -2.02261e-013)) (268 15.7065 (11.4327 6.74101 -2.01565e-013)) (269 16.0067 (11.3778 6.82462 -2.00843e-013)) (270 16.3147 (11.3204 6.90651 -2.00095e-013)) (271 16.632 (11.2606 6.98666 -1.99324e-013)) (272 16.9596 (11.1985 7.06504 -1.98532e-013)) (273 17.2993 (11.1343 7.14164 -1.9772e-013)) (274 17.6527 (11.0679 7.21642 -1.96891e-013)) (275 18.0218 (10.9995 7.28936 -1.96044e-013)) (276 18.4089 (10.9291 7.36044 -1.95183e-013)) (277 18.8167 (10.8569 7.42962 -1.94307e-013)) (278 19.2483 (10.7829 7.49689 -1.93419e-013)) (279 19.7074 (10.7072 7.5622 -1.9252e-013)) (280 20.1984 (10.6298 7.62553 -1.9161e-013)) (281 20.7265 (10.5508 7.68684 -1.90692e-013)) (282 21.2981 (10.4703 7.74607 -1.89766e-013)) (283 21.921 (10.3882 7.80319 -1.88833e-013)) (284 22.6048 (10.3046 7.85814 -1.87895e-013)) (285 23.3615 (10.2197 7.91085 -1.86953e-013)) (286 24.2066 (10.1333 7.96127 -1.86008e-013)) (287 25.1597 (10.0456 8.00932 -1.85061e-013)) (288 26.247 (9.9566 8.05491 -1.84114e-013)) (289 27.5033 (9.86634 8.09795 -1.83167e-013)) (290 28.9766 (9.77487 8.13835 -1.82223e-013)) (291 30.7345 (9.68223 8.17599 -1.81283e-013)) (292 32.8758 (9.58847 8.21074 -1.80348e-013)) (293 35.5502 (9.49364 8.24248 -1.79421e-013)) (294 38.9968 (9.39781 8.27105 -1.78503e-013)) (295 43.6217 (9.30106 8.29629 -1.77596e-013)) (296 50.1747 (9.20346 8.31803 -1.76704e-013)) (297 60.2108 (9.1051 8.33608 -1.75827e-013)) (298 77.5666 (9.00612 8.35022 -1.7497e-013)) (299 114.859 (8.90663 8.36025 -1.74134e-013)) (300 163.434 (8.8285 8.36508 -1.73498e-013)) (301 260.175 (8.7286 8.3695 -1.75001e-013)) (302 7191.77 (8.62863 8.37173 -1.7422e-013)))    
  )
)

)

;															





  
  

	;	PARANDO																						
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)

) ;CIERRE DEFUN VERTICES-POL-01

;=====================================================================================================================================================

